CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{8A61A686-729C-445F-A9FE-EE770EDE1BCB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{A249751D-7FEF-4E7D-901C-F0189B1353D3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{9C67ABCF-AF0A-4712-9B46-2AE3A7F2CADE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{1FCA4423-A02F-4ED4-8896-0960CA22CADD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{E64893A6-9A57-4DEF-B80D-8152A5830C58}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{C6860139-D708-4819-A385-8699835EB9A2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{6A5B6946-4D58-43D2-9985-8446E6FF4EB5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{A91C068C-EF7B-45F3-B16A-763B32A13CAE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{2449139F-A110-4627-86F5-2D0D19AAEB3F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{AB717935-FED1-4D6A-8C0E-D7587305441B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{8DE83E4F-41CF-4403-ADAC-B8AB7951AEB2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{142B6053-56FD-401C-A245-589F29108562}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{060C894C-14C4-46C6-BECB-05DF18F1E950}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{2C88E022-C3A6-425C-A12E-E2810D4280AC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{42F375C9-2D7C-480C-AD0C-02365921BF89}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{9796C33A-E04D-4FB3-AAA3-6E2D2A21F9AB}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{CAF1686F-EB1C-4DDC-8F76-AB26EB2E1C0D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{E1EC51F3-D89F-4D7C-A07C-FF8F7046AF11}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{47292764-9533-43D1-A5C2-0B955C7192C9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{7D2C86E2-0940-4983-94D3-ACABEAE8F964}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{31170C41-BC31-4DA4-A36E-822C7AF8139D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{BBDA1427-A6E0-4143-978F-763AA19C3EA8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{EF8F3EB5-824F-4EC3-B64D-2CBA76BB2AC7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{DCD8C8A2-DBE4-4DB0-90F1-963A3D874B5B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{BE57DD17-53C2-4650-9841-481D45CEAEFF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{979F0749-A302-4753-9AD1-7B87F5B6DCF9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{C54C2F23-469F-417A-9B98-40E281712B3B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{6C8FACAB-36FC-4C21-BCDB-8CFF7D901080}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{42B7F75C-2620-44E3-914F-1623EA462DA6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{CC6D4DC3-2C0F-469E-AEFF-25C460805264}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{B413D854-2749-485F-AE9F-4483261E2EBD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{96509222-97B8-45F1-A871-AFB801CBEAAF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{0CD0BA5E-E4F6-4ABA-96EB-366F2419E494}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{AAAA91C3-F8C5-4D44-B1F4-CB303CD78517}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{DC91BDB3-651F-4C8A-AB5C-88F04D72C96B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{2BCF64FD-6AF0-4824-9DF3-94AF0513EB86}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{45B85662-5AC7-45ED-AE7C-6FBD846D6E8C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{A31E81A1-E490-4CB8-8F3C-BD88E41878F4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{5309D4D7-F9B3-4632-9FA2-1E55F28A99AE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{746DCDDC-C05A-4196-B58C-9D847155BB15}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{1B3F37DD-1D67-4EF8-9E46-E0C0DE8EE54E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{57224040-64E2-4583-B088-3D0432D497CA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{4AB04984-FDBB-4C15-8257-5001A2A468B0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{F0904A0A-0B7B-467D-AD1F-8DF5788F49E1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{B1209583-BDCA-41B5-B744-9DDED7CD6B06}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{4DA6DB30-487E-47D9-BE06-484B98E8F195}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{343ED8E2-E3EC-40B0-A5E3-42A4031E7A26}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{715A85BB-2E28-4326-BD3D-221C11D8B0E3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{319DA45D-4280-4959-860F-F691C6E9FECA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{72A3DDC3-57F6-48B3-93D6-C97B5B3F5426}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{3E3CAEBD-D933-4419-BB07-360F48737236}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{5659D941-1DEA-4115-ABA5-96E4739B706C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{9A756F39-8953-4DA5-9BA6-3870959372F5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{EBA6A8B9-C2DF-4E8A-BC33-537795DCBF0C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{646BF370-48D9-4EDD-A226-EA57D20DA498}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{9B70C550-FDE6-4F8A-BA54-87EBB19D8217}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{AC6E172C-4451-4C20-A010-7D6EA4132080}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{A9F7701B-D902-4DB6-A4CE-B719E8ACABF9}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{0EF96E20-391E-439F-A8EC-D0CE631F01B0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{FE864F6E-9F82-44C6-B603-4BC12EDD2B42}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{C18CA3EB-4514-431E-870B-D450123A4F37}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{92D9905F-28BC-4060-BFA8-63E2F66EA83F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{0A45236E-F5C6-412A-957B-4A137BE23368}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{8EE77B56-692E-4365-AEF1-97E418B2ACD0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{C8C71F1A-8377-4DEA-B2B6-22B50613A7F1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{F7B88F8A-740F-4DD9-BC93-AFBFFDE2ED30}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{B438E191-939E-4CBA-96E7-0B385465BACD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{C696F4F7-0296-4B31-B568-73F0C750BFE3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{175A434A-D038-487A-A4FA-F6D644C42B69}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{45253FB9-1758-4A9C-83AC-DCCE379900F3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{3DBDA6E1-6D27-4AE0-836F-02EDFC74B8E6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{62B7F790-128E-4930-BF32-08723D90205B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{4F33B2F7-489A-47F5-9B76-2B8A0520CB74}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{B5571C07-005D-4444-B97D-CC90A41688F5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{C6DAD953-A300-4EC0-9EF8-7F29142D8113}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{E4BCE476-06DB-422A-A7A0-9EFCA3905B5A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{5F44EB36-4459-47BD-9CB0-C071F0930EBC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{A351EA04-5962-4F3C-A523-9E0713DE9D87}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{CE5302F1-BABD-4C4C-9DCD-2422C8E126C0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{645CF1E8-06A4-4D1E-A621-A1087BF642F5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{EE4F0A3D-D5DD-47CE-A9F3-57F074C08789}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{8F1F7422-FEAE-4658-80F2-F0DB4EA160B0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{C061B93E-E151-4D24-A8AC-F124F85CB563}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{32B456FC-6028-4913-A1B6-3AA1E78C38FE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{F91A2120-5830-4C3B-B204-0F385C8DB68E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{D605446D-A698-4113-86EE-A2CB1763D3E7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{3E371FCE-86AD-4A2F-95D5-F86C4E0FA565}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{A15C1863-83B1-479D-A243-4D709992D769}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{A5934943-EC27-40C1-9062-A6D708431FD5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{FEF6F5DC-E2A9-40BC-9085-7C38470966BE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{836BCD14-9B5B-403C-9F88-C6FE2EFEB9CD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{D606BC40-563B-4860-A6DF-EA4A2F1F350D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{664C198E-D202-4E19-8B55-7BECFD5EE574}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{71B83C01-57FD-46BE-9B23-3C48E034E155}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{695E5FE5-630A-4C5E-8CBB-8047306E4ABA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{BB5D1E26-037C-423C-A130-141A8B8469F6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{E89A9356-6854-4473-92E2-3A27CBC6EF71}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{07ABA060-AE83-4E08-8389-A460F07FC196}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{704C5D11-50C0-457E-B213-41E124FBD35A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{F2274C5D-83E1-4D47-AF93-B2446CF0334D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{C795DA7C-DBE1-41F9-BD5F-18948FB23E8B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{6282F52B-65A7-4AD5-A421-C9EE9EF977A1}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{CB08034F-1F1A-49A0-98CB-75DDDFEA792C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{18F3BC5A-DE33-4A06-8473-5091EF8BE5EE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{56F4E9A6-EB48-421F-9BB4-CA7DD0AECF29}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{153C1D6A-5FF7-4BF6-A3F8-3A0460B88641}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{FB4E867C-EF34-4FD1-A3B6-4B258FFB4328}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{07EF416D-DB54-4018-83A7-8B5C6A79B0BD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{2DD052A2-274C-4DF1-8549-0F25A8057954}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{FDA8DBA5-F43E-4E93-9399-C8FCFE334A1D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{2EFB11AD-408D-4ABC-83C2-7B597B12FD72}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{16B6FC3E-BDDA-453A-88FD-4737797F1C5B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{3AE0977D-5A75-42B6-A467-05EF8BBFC40D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{536CF532-DB15-4C08-B450-07FB4393F923}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{FA4BC479-3936-421C-929B-85A972E3EC08}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{E650B365-8ECE-459A-953A-D060933CC6F7}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{7DFEBE89-D935-4552-9480-243DD6E1D337}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{F1A88B84-2042-4F71-B799-2455FB964EDC}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{21D6D93B-3136-47D8-B895-A68293AACCB2}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{1DA0F9DC-060F-46B2-9834-236A926CD196}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{B42F85B9-79D6-4C93-A58D-3334D0965D6C}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{0E5FAAB8-6E59-4625-A2BF-0A00B59D5B44}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{CE2CABE4-FB44-453F-9460-F2AFBD6C5516}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{B639E773-E1DA-4D8E-927C-EA6CA6317153}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{5D787AD2-424C-4723-AB72-277D4B5D82DF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{7D1A3B9B-D462-455E-B7CC-57EEC4A68022}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{FF124E3F-F46E-4327-818B-5CCC2492B4B0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{C43B5317-3CD4-42DC-959D-3D6C21EE5506}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{C0CD56EC-C793-4C2D-9180-EA7B359EFE6D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{E72A98BE-DE84-42BC-AAF1-67758DF12D1B}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{7416959D-DFD1-4DF5-9C7F-9E4DABE9D6F0}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{D41DC955-CE88-472F-BD34-11E85D7EE83A}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{87D7BB92-0FBE-49D9-8B09-04FDCFB8085E}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{7A68D1FE-8572-4E29-B85B-43BAD7EA2F90}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{F9754E5B-E402-4ABF-9DB0-246F158E56F3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{188DB348-27A5-4319-9342-35F8F4046F84}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{F7A51F57-9156-4B56-9B89-1F7C2922828F}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{E51D4BDD-E4B4-4108-A509-CCFC46C441C5}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{70ECE3F5-0436-4674-B7DD-D9980A22DC83}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{A77F625D-BEF5-44DF-A9B4-A362D9F31236}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{BEF4D236-FB96-4357-AA8C-5D2C520851AA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{648443DB-EF42-4341-AC24-EFAE26517622}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{66EFC428-E07C-4478-A74B-9E3393110284}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{34129EEF-1652-4D10-A00A-D5146C1ED757}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{73EB93BC-D19C-4C75-A2CB-DFE47F6126E6}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{2BCBAB8E-DE63-4C4C-9BD3-ACC497E3E6EF}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{14FEBF83-AFC3-4B1D-9C19-B15776AF0852}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{BBE3193A-6052-4B8D-8F54-CF2D74E2A2AE}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{B704FAEA-A9E2-4E01-BD42-217B7CF0C1E4}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{088911D2-9638-4C1F-92AC-327E5FD3BEA3}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{8BD677D5-AA8D-41F9-B043-651E382D54DD}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{1482A23C-3C3B-4898-93CF-1D9248D3C1EA}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{83BB841A-BCB4-4756-8ED0-30F12D8468C8}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{F7747C2C-56E3-4D04-A87C-5D9431C2FF82}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "{B20F7B76-D098-4131-99FA-76C7436E778D}", "conflict", "", "", "")
INSERT INTO DependencyData VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "", "langPack", "Captivate", "Adobe Captivate", "5")
INSERT INTO Payloads VALUES	("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "Captivate", "Adobe Captivate_AdobeCaptivate5de_DELanguagePack", "5", "langPack")
INSERT INTO PayloadData VALUES("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "0" , "PayloadInfo", '<PayloadInfo version="3.0.116.0"><BuildInfo>
    <Property name="Created">2010-05-22 02:35:59.348000</Property>
    <Property name="TargetName">AdobeCaptivate5de_DELanguagePack</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}</Property>
    <Property name="ProductName">Adobe Captivate de_DE Language Pack</Property>
    <Property name="ProductVersion">5</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeProgramFiles]</Platform>
  </InstallDir><Languages>
    <Language>de_DE</Language>
  </Languages><Satisfies>
    <ProductInfo>
		<Family>Captivate</Family>
		<ProductName minVersion="5">Adobe Captivate_AdobeCaptivate5de_DELanguagePack</ProductName>
	<ProductVersion>5</ProductVersion>
    </ProductInfo>
  </Satisfies><Conflicts>
    <AdobeCode>{8A61A686-729C-445F-A9FE-EE770EDE1BCB}</AdobeCode>
    <AdobeCode>{A249751D-7FEF-4E7D-901C-F0189B1353D3}</AdobeCode>
    <AdobeCode>{9C67ABCF-AF0A-4712-9B46-2AE3A7F2CADE}</AdobeCode>
    <AdobeCode>{1FCA4423-A02F-4ED4-8896-0960CA22CADD}</AdobeCode>
    <AdobeCode>{E64893A6-9A57-4DEF-B80D-8152A5830C58}</AdobeCode>
    <AdobeCode>{C6860139-D708-4819-A385-8699835EB9A2}</AdobeCode>
    <AdobeCode>{6A5B6946-4D58-43D2-9985-8446E6FF4EB5}</AdobeCode>
    <AdobeCode>{A91C068C-EF7B-45F3-B16A-763B32A13CAE}</AdobeCode>
    <AdobeCode>{2449139F-A110-4627-86F5-2D0D19AAEB3F}</AdobeCode>
    <AdobeCode>{AB717935-FED1-4D6A-8C0E-D7587305441B}</AdobeCode>
    <AdobeCode>{8DE83E4F-41CF-4403-ADAC-B8AB7951AEB2}</AdobeCode>
    <AdobeCode>{142B6053-56FD-401C-A245-589F29108562}</AdobeCode>
    <AdobeCode>{060C894C-14C4-46C6-BECB-05DF18F1E950}</AdobeCode>
    <AdobeCode>{2C88E022-C3A6-425C-A12E-E2810D4280AC}</AdobeCode>
    <AdobeCode>{42F375C9-2D7C-480C-AD0C-02365921BF89}</AdobeCode>
    <AdobeCode>{9796C33A-E04D-4FB3-AAA3-6E2D2A21F9AB}</AdobeCode>
    <AdobeCode>{CAF1686F-EB1C-4DDC-8F76-AB26EB2E1C0D}</AdobeCode>
    <AdobeCode>{E1EC51F3-D89F-4D7C-A07C-FF8F7046AF11}</AdobeCode>
    <AdobeCode>{47292764-9533-43D1-A5C2-0B955C7192C9}</AdobeCode>
    <AdobeCode>{7D2C86E2-0940-4983-94D3-ACABEAE8F964}</AdobeCode>
    <AdobeCode>{31170C41-BC31-4DA4-A36E-822C7AF8139D}</AdobeCode>
    <AdobeCode>{BBDA1427-A6E0-4143-978F-763AA19C3EA8}</AdobeCode>
    <AdobeCode>{EF8F3EB5-824F-4EC3-B64D-2CBA76BB2AC7}</AdobeCode>
    <AdobeCode>{DCD8C8A2-DBE4-4DB0-90F1-963A3D874B5B}</AdobeCode>
    <AdobeCode>{BE57DD17-53C2-4650-9841-481D45CEAEFF}</AdobeCode>
    <AdobeCode>{979F0749-A302-4753-9AD1-7B87F5B6DCF9}</AdobeCode>
    <AdobeCode>{C54C2F23-469F-417A-9B98-40E281712B3B}</AdobeCode>
    <AdobeCode>{6C8FACAB-36FC-4C21-BCDB-8CFF7D901080}</AdobeCode>
    <AdobeCode>{42B7F75C-2620-44E3-914F-1623EA462DA6}</AdobeCode>
    <AdobeCode>{CC6D4DC3-2C0F-469E-AEFF-25C460805264}</AdobeCode>
    <AdobeCode>{B413D854-2749-485F-AE9F-4483261E2EBD}</AdobeCode>
    <AdobeCode>{96509222-97B8-45F1-A871-AFB801CBEAAF}</AdobeCode>
    <AdobeCode>{0CD0BA5E-E4F6-4ABA-96EB-366F2419E494}</AdobeCode>
    <AdobeCode>{AAAA91C3-F8C5-4D44-B1F4-CB303CD78517}</AdobeCode>
    <AdobeCode>{DC91BDB3-651F-4C8A-AB5C-88F04D72C96B}</AdobeCode>
    <AdobeCode>{2BCF64FD-6AF0-4824-9DF3-94AF0513EB86}</AdobeCode>
    <AdobeCode>{45B85662-5AC7-45ED-AE7C-6FBD846D6E8C}</AdobeCode>
    <AdobeCode>{A31E81A1-E490-4CB8-8F3C-BD88E41878F4}</AdobeCode>
    <AdobeCode>{5309D4D7-F9B3-4632-9FA2-1E55F28A99AE}</AdobeCode>
    <AdobeCode>{746DCDDC-C05A-4196-B58C-9D847155BB15}</AdobeCode>
    <AdobeCode>{1B3F37DD-1D67-4EF8-9E46-E0C0DE8EE54E}</AdobeCode>
    <AdobeCode>{57224040-64E2-4583-B088-3D0432D497CA}</AdobeCode>
    <AdobeCode>{4AB04984-FDBB-4C15-8257-5001A2A468B0}</AdobeCode>
    <AdobeCode>{F0904A0A-0B7B-467D-AD1F-8DF5788F49E1}</AdobeCode>
    <AdobeCode>{B1209583-BDCA-41B5-B744-9DDED7CD6B06}</AdobeCode>
    <AdobeCode>{4DA6DB30-487E-47D9-BE06-484B98E8F195}</AdobeCode>
    <AdobeCode>{343ED8E2-E3EC-40B0-A5E3-42A4031E7A26}</AdobeCode>
    <AdobeCode>{715A85BB-2E28-4326-BD3D-221C11D8B0E3}</AdobeCode>
    <AdobeCode>{319DA45D-4280-4959-860F-F691C6E9FECA}</AdobeCode>
    <AdobeCode>{72A3DDC3-57F6-48B3-93D6-C97B5B3F5426}</AdobeCode>
    <AdobeCode>{3E3CAEBD-D933-4419-BB07-360F48737236}</AdobeCode>
    <AdobeCode>{5659D941-1DEA-4115-ABA5-96E4739B706C}</AdobeCode>
    <AdobeCode>{9A756F39-8953-4DA5-9BA6-3870959372F5}</AdobeCode>
    <AdobeCode>{EBA6A8B9-C2DF-4E8A-BC33-537795DCBF0C}</AdobeCode>
    <AdobeCode>{646BF370-48D9-4EDD-A226-EA57D20DA498}</AdobeCode>
    <AdobeCode>{9B70C550-FDE6-4F8A-BA54-87EBB19D8217}</AdobeCode>
    <AdobeCode>{AC6E172C-4451-4C20-A010-7D6EA4132080}</AdobeCode>
    <AdobeCode>{A9F7701B-D902-4DB6-A4CE-B719E8ACABF9}</AdobeCode>
    <AdobeCode>{0EF96E20-391E-439F-A8EC-D0CE631F01B0}</AdobeCode>
    <AdobeCode>{FE864F6E-9F82-44C6-B603-4BC12EDD2B42}</AdobeCode>
    <AdobeCode>{C18CA3EB-4514-431E-870B-D450123A4F37}</AdobeCode>
    <AdobeCode>{92D9905F-28BC-4060-BFA8-63E2F66EA83F}</AdobeCode>
    <AdobeCode>{0A45236E-F5C6-412A-957B-4A137BE23368}</AdobeCode>
    <AdobeCode>{8EE77B56-692E-4365-AEF1-97E418B2ACD0}</AdobeCode>
    <AdobeCode>{C8C71F1A-8377-4DEA-B2B6-22B50613A7F1}</AdobeCode>
    <AdobeCode>{F7B88F8A-740F-4DD9-BC93-AFBFFDE2ED30}</AdobeCode>
    <AdobeCode>{B438E191-939E-4CBA-96E7-0B385465BACD}</AdobeCode>
    <AdobeCode>{C696F4F7-0296-4B31-B568-73F0C750BFE3}</AdobeCode>
    <AdobeCode>{175A434A-D038-487A-A4FA-F6D644C42B69}</AdobeCode>
    <AdobeCode>{45253FB9-1758-4A9C-83AC-DCCE379900F3}</AdobeCode>
    <AdobeCode>{3DBDA6E1-6D27-4AE0-836F-02EDFC74B8E6}</AdobeCode>
    <AdobeCode>{62B7F790-128E-4930-BF32-08723D90205B}</AdobeCode>
    <AdobeCode>{4F33B2F7-489A-47F5-9B76-2B8A0520CB74}</AdobeCode>
    <AdobeCode>{B5571C07-005D-4444-B97D-CC90A41688F5}</AdobeCode>
    <AdobeCode>{C6DAD953-A300-4EC0-9EF8-7F29142D8113}</AdobeCode>
    <AdobeCode>{E4BCE476-06DB-422A-A7A0-9EFCA3905B5A}</AdobeCode>
    <AdobeCode>{5F44EB36-4459-47BD-9CB0-C071F0930EBC}</AdobeCode>
    <AdobeCode>{A351EA04-5962-4F3C-A523-9E0713DE9D87}</AdobeCode>
    <AdobeCode>{CE5302F1-BABD-4C4C-9DCD-2422C8E126C0}</AdobeCode>
    <AdobeCode>{645CF1E8-06A4-4D1E-A621-A1087BF642F5}</AdobeCode>
    <AdobeCode>{EE4F0A3D-D5DD-47CE-A9F3-57F074C08789}</AdobeCode>
    <AdobeCode>{8F1F7422-FEAE-4658-80F2-F0DB4EA160B0}</AdobeCode>
    <AdobeCode>{C061B93E-E151-4D24-A8AC-F124F85CB563}</AdobeCode>
    <AdobeCode>{32B456FC-6028-4913-A1B6-3AA1E78C38FE}</AdobeCode>
    <AdobeCode>{F91A2120-5830-4C3B-B204-0F385C8DB68E}</AdobeCode>
    <AdobeCode>{D605446D-A698-4113-86EE-A2CB1763D3E7}</AdobeCode>
    <AdobeCode>{3E371FCE-86AD-4A2F-95D5-F86C4E0FA565}</AdobeCode>
    <AdobeCode>{A15C1863-83B1-479D-A243-4D709992D769}</AdobeCode>
    <AdobeCode>{A5934943-EC27-40C1-9062-A6D708431FD5}</AdobeCode>
    <AdobeCode>{FEF6F5DC-E2A9-40BC-9085-7C38470966BE}</AdobeCode>
    <AdobeCode>{836BCD14-9B5B-403C-9F88-C6FE2EFEB9CD}</AdobeCode>
    <AdobeCode>{D606BC40-563B-4860-A6DF-EA4A2F1F350D}</AdobeCode>
    <AdobeCode>{664C198E-D202-4E19-8B55-7BECFD5EE574}</AdobeCode>
    <AdobeCode>{71B83C01-57FD-46BE-9B23-3C48E034E155}</AdobeCode>
    <AdobeCode>{695E5FE5-630A-4C5E-8CBB-8047306E4ABA}</AdobeCode>
    <AdobeCode>{BB5D1E26-037C-423C-A130-141A8B8469F6}</AdobeCode>
    <AdobeCode>{E89A9356-6854-4473-92E2-3A27CBC6EF71}</AdobeCode>
    <AdobeCode>{07ABA060-AE83-4E08-8389-A460F07FC196}</AdobeCode>
    <AdobeCode>{704C5D11-50C0-457E-B213-41E124FBD35A}</AdobeCode>
    <AdobeCode>{F2274C5D-83E1-4D47-AF93-B2446CF0334D}</AdobeCode>
    <AdobeCode>{C795DA7C-DBE1-41F9-BD5F-18948FB23E8B}</AdobeCode>
    <AdobeCode>{6282F52B-65A7-4AD5-A421-C9EE9EF977A1}</AdobeCode>
    <AdobeCode>{CB08034F-1F1A-49A0-98CB-75DDDFEA792C}</AdobeCode>
    <AdobeCode>{18F3BC5A-DE33-4A06-8473-5091EF8BE5EE}</AdobeCode>
    <AdobeCode>{56F4E9A6-EB48-421F-9BB4-CA7DD0AECF29}</AdobeCode>
    <AdobeCode>{153C1D6A-5FF7-4BF6-A3F8-3A0460B88641}</AdobeCode>
    <AdobeCode>{FB4E867C-EF34-4FD1-A3B6-4B258FFB4328}</AdobeCode>
    <AdobeCode>{07EF416D-DB54-4018-83A7-8B5C6A79B0BD}</AdobeCode>
    <AdobeCode>{2DD052A2-274C-4DF1-8549-0F25A8057954}</AdobeCode>
    <AdobeCode>{FDA8DBA5-F43E-4E93-9399-C8FCFE334A1D}</AdobeCode>
    <AdobeCode>{2EFB11AD-408D-4ABC-83C2-7B597B12FD72}</AdobeCode>
    <AdobeCode>{16B6FC3E-BDDA-453A-88FD-4737797F1C5B}</AdobeCode>
    <AdobeCode>{3AE0977D-5A75-42B6-A467-05EF8BBFC40D}</AdobeCode>
    <AdobeCode>{536CF532-DB15-4C08-B450-07FB4393F923}</AdobeCode>
    <AdobeCode>{FA4BC479-3936-421C-929B-85A972E3EC08}</AdobeCode>
    <AdobeCode>{E650B365-8ECE-459A-953A-D060933CC6F7}</AdobeCode>
    <AdobeCode>{7DFEBE89-D935-4552-9480-243DD6E1D337}</AdobeCode>
    <AdobeCode>{F1A88B84-2042-4F71-B799-2455FB964EDC}</AdobeCode>
    <AdobeCode>{21D6D93B-3136-47D8-B895-A68293AACCB2}</AdobeCode>
    <AdobeCode>{1DA0F9DC-060F-46B2-9834-236A926CD196}</AdobeCode>
    <AdobeCode>{B42F85B9-79D6-4C93-A58D-3334D0965D6C}</AdobeCode>
    <AdobeCode>{0E5FAAB8-6E59-4625-A2BF-0A00B59D5B44}</AdobeCode>
    <AdobeCode>{CE2CABE4-FB44-453F-9460-F2AFBD6C5516}</AdobeCode>
    <AdobeCode>{B639E773-E1DA-4D8E-927C-EA6CA6317153}</AdobeCode>
    <AdobeCode>{5D787AD2-424C-4723-AB72-277D4B5D82DF}</AdobeCode>
    <AdobeCode>{7D1A3B9B-D462-455E-B7CC-57EEC4A68022}</AdobeCode>
    <AdobeCode>{FF124E3F-F46E-4327-818B-5CCC2492B4B0}</AdobeCode>
    <AdobeCode>{C43B5317-3CD4-42DC-959D-3D6C21EE5506}</AdobeCode>
    <AdobeCode>{C0CD56EC-C793-4C2D-9180-EA7B359EFE6D}</AdobeCode>
    <AdobeCode>{E72A98BE-DE84-42BC-AAF1-67758DF12D1B}</AdobeCode>
    <AdobeCode>{7416959D-DFD1-4DF5-9C7F-9E4DABE9D6F0}</AdobeCode>
    <AdobeCode>{D41DC955-CE88-472F-BD34-11E85D7EE83A}</AdobeCode>
    <AdobeCode>{87D7BB92-0FBE-49D9-8B09-04FDCFB8085E}</AdobeCode>
    <AdobeCode>{7A68D1FE-8572-4E29-B85B-43BAD7EA2F90}</AdobeCode>
    <AdobeCode>{F9754E5B-E402-4ABF-9DB0-246F158E56F3}</AdobeCode>
    <AdobeCode>{188DB348-27A5-4319-9342-35F8F4046F84}</AdobeCode>
    <AdobeCode>{F7A51F57-9156-4B56-9B89-1F7C2922828F}</AdobeCode>
    <AdobeCode>{E51D4BDD-E4B4-4108-A509-CCFC46C441C5}</AdobeCode>
    <AdobeCode>{70ECE3F5-0436-4674-B7DD-D9980A22DC83}</AdobeCode>
    <AdobeCode>{A77F625D-BEF5-44DF-A9B4-A362D9F31236}</AdobeCode>
    <AdobeCode>{BEF4D236-FB96-4357-AA8C-5D2C520851AA}</AdobeCode>
    <AdobeCode>{648443DB-EF42-4341-AC24-EFAE26517622}</AdobeCode>
    <AdobeCode>{66EFC428-E07C-4478-A74B-9E3393110284}</AdobeCode>
    <AdobeCode>{34129EEF-1652-4D10-A00A-D5146C1ED757}</AdobeCode>
    <AdobeCode>{73EB93BC-D19C-4C75-A2CB-DFE47F6126E6}</AdobeCode>
    <AdobeCode>{2BCBAB8E-DE63-4C4C-9BD3-ACC497E3E6EF}</AdobeCode>
    <AdobeCode>{14FEBF83-AFC3-4B1D-9C19-B15776AF0852}</AdobeCode>
    <AdobeCode>{BBE3193A-6052-4B8D-8F54-CF2D74E2A2AE}</AdobeCode>
    <AdobeCode>{B704FAEA-A9E2-4E01-BD42-217B7CF0C1E4}</AdobeCode>
    <AdobeCode>{088911D2-9638-4C1F-92AC-327E5FD3BEA3}</AdobeCode>
    <AdobeCode>{8BD677D5-AA8D-41F9-B043-651E382D54DD}</AdobeCode>
    <AdobeCode>{1482A23C-3C3B-4898-93CF-1D9248D3C1EA}</AdobeCode>
    <AdobeCode>{83BB841A-BCB4-4756-8ED0-30F12D8468C8}</AdobeCode>
    <AdobeCode>{F7747C2C-56E3-4D04-A87C-5D9431C2FF82}</AdobeCode>
    <AdobeCode>{B20F7B76-D098-4131-99FA-76C7436E778D}</AdobeCode>
  </Conflicts><Channel enable="1" id="AdobeCaptivate5de_DELanguagePack">
    <DisplayName>Adobe Captivate de_DE Language Pack</DisplayName>
  </Channel><Extends type="langPack">
    <ParentProductInfo minVersion="5">
					<Family>Captivate</Family>
					<ProductName>Adobe Captivate</ProductName>
				</ParentProductInfo>
  </Extends><InstallDestinationMetadata relocatableSize="5706588" sysDriveSize="314"><Destination>
      <Root>[INSTALLDIR]</Root>
      <TotalSize>5706588</TotalSize>
      <MaxPathComponent>/Adobe Captivate 5/de_DE/Gallery/Preloaders/AS3\hand cursor loading.fla</MaxPathComponent>
    </Destination>
    <Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>314</TotalSize>
      <MaxPathComponent>/HelpCfg/de_DE\Captivate_5.0.helpcfg</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="314"/>
      <Asset flag="1" name="Assets1_1" size="5706588"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	</Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="de_DE">5</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="de_DE">Adobe Captivate de_DE Language Pack</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "0", "ChannelID", "AdobeCaptivate5de_DELanguagePack")
INSERT INTO PayloadData VALUES("{14FAE750-0D51-4B5A-90D3-9D84AA2B7890}", "0", "ChannelInfo", '<Channel enable="1" id="AdobeCaptivate5de_DELanguagePack">
    <DisplayName>Adobe Captivate de_DE Language Pack</DisplayName>
  </Channel>')
